<?php
/**
 * The Page Sidebar containing the widget area.
 *
 * @package Betheme
 * @author Muffin group
 * @link https://muffingroup.com
 */

$sidebars = mfn_opts_get('sidebars');
$sidebar = $sidebar2 = '';

// sidebar 1

if (get_post_type() == 'page' && mfn_opts_get('single-page-sidebar')) {

	// theme options: single page
	$sidebar = trim(mfn_opts_get('single-page-sidebar'));

} elseif (get_post_type() == 'post' && is_single() && mfn_opts_get('single-sidebar')) {

	// theme options: single post
	$sidebar = trim(mfn_opts_get('single-sidebar'));

} elseif (get_post_type() == 'portfolio' && is_single() && mfn_opts_get('single-portfolio-sidebar')) {

	// theme options: single portfolio
	$sidebar = trim(mfn_opts_get('single-portfolio-sidebar'));

} elseif (is_array($sidebars)) {

	// post meta
	$sidebar = get_post_meta(mfn_ID(), 'mfn-post-sidebar', true);
	if ($sidebar || $sidebar === '0') {
		$sidebar = $sidebars[ $sidebar ];
	}

}

if ($_GET && key_exists('mfn-s', $_GET)) {
	$sidebar = esc_html($_GET['mfn-s']); // demo
}

// sidebar 2

if (get_post_type() == 'page' && mfn_opts_get('single-page-sidebar2')) {

	// theme options: single page
	$sidebar2 = trim(mfn_opts_get('single-page-sidebar2'));

} elseif (get_post_type() == 'post' && is_single() && mfn_opts_get('single-sidebar2')) {

	// theme options: single post
	$sidebar2 = trim(mfn_opts_get('single-sidebar2'));

} elseif (get_post_type() == 'portfolio' && is_single() && mfn_opts_get('single-portfolio-sidebar2')) {

	// theme options: single portfolio
	$sidebar2 = trim(mfn_opts_get('single-portfolio-sidebar2'));

} elseif (is_array($sidebars)) {

	// post meta
	$sidebar2 = get_post_meta(mfn_ID(), 'mfn-post-sidebar2', true);
	if ($sidebar2 || $sidebar2 === '0') {
		$sidebar2 = $sidebars[ $sidebar2 ];
	}

}

if ($_GET && key_exists('mfn-s2', $_GET)) {
	$sidebar2 = esc_html($_GET['mfn-s2']); // demo
}

// output -----

if (mfn_sidebar_classes()) {

	echo '<div class="sidebar sidebar-1 four columns">';
		echo '<div class="widget-area clearfix '. esc_attr(mfn_opts_get('sidebar-lines')) .'">';
			if (function_exists('is_buddypress') && is_buddypress() && is_active_sidebar('buddy')) {
				dynamic_sidebar('buddy');
			} elseif (! dynamic_sidebar($sidebar)) {
				mfn_nosidebar();
			}
		echo '</div>';
	echo '</div>';

	// both sidebars

	if (mfn_sidebar_classes(true)) {
		echo '<div class="sidebar sidebar-2 four columns">';
			echo '<div class="widget-area clearfix '. esc_attr(mfn_opts_get('sidebar-lines')) .'">';
				if (! dynamic_sidebar($sidebar2)) {
					mfn_nosidebar();
				}
			echo '</div>';
		echo '</div>';
	}
}
