<?php
/**
 * Template Name: Blank Page
 *
 * @package Betheme
 * @author Muffin Group
 * @link https://muffingroup.com
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php echo esc_attr(mfn_user_os()); ?>"<?php mfn_tag_schema(); ?>>

<head>

<meta charset="<?php bloginfo('charset'); ?>" />
<?php
	if (mfn_opts_get('responsive')) {
		if (mfn_opts_get('responsive-zoom')) {
			echo '<meta name="viewport" content="width=device-width, initial-scale=1" />';
		} else {
			echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />';
		}
	}
?>

<?php do_action('wp_seo'); ?>

<link rel="shortcut icon" href="<?php echo esc_url(mfn_opts_get('favicon-img', get_theme_file_uri('/images/favicon.ico'))); ?>" type="image/x-icon" />

<?php wp_head(); ?>

</head>

<body <?php body_class('template-blank'); ?>>

	<?php do_action('mfn_hook_top'); ?>

	<?php do_action('mfn_hook_content_before'); ?>

	<div id="Content">
		<div class="content_wrapper clearfix">

			<div class="sections_group">
				<?php
					while (have_posts()) {
						the_post();
						mfn_builder_print(get_the_ID());
					}
				?>
			</div>

			<?php get_sidebar(); ?>

		</div>
	</div>

	<?php do_action('mfn_hook_content_after'); ?>

	<?php do_action('mfn_hook_bottom'); ?>

<?php wp_footer(); ?>

</body>
</html>
